# Changelog — LapMinAcc

All notable changes to the Laptop Ministry Accounting System are documented here.

---

## [1.03] — 2026-02-26

### Added
- **Public home page** (`index.php`) with laptop request submission, fulfillment statistics, and inventory overview
- **Math captcha** on the public request form and the staff login page to block automated submissions
- **Honeypot field** on the public request form for bot detection
- **Welcome modal** shown to first-time public visitors; content editable by staff from the dashboard
- **Dashboard** (`dashboard.php`) with waitlist and inventory summary metrics and organization settings editor
- **Waitlist management** (`waitlist.php`) — add, edit, delete, search, filter, and assign inventory items to recipients
- **Inventory management** (`inventory.php`) — log donated computers and parts, track status, donor info, value, and tax letter requests
- **Reports** (`reports.php`) — categorize waitlist entries by need type, filter by date range, view monthly trends, and export CSV
- **Import** (`import.php`) — upload waitlist or inventory data from CSV with column mapping, preview, and row-level error reporting
- **Export** (`export.php`) — download full waitlist CSV, full inventory CSV, or a specialized pickup report with date-difference calculations
- **Reconcile** (`reconcile.php`) — detect and repair orphaned inventory references between waitlist and inventory records
- **User management** (`users.php`) — create and delete staff accounts with Admin, Editor, or Auditor roles
- **Profile page** (`profile.php`) — allow any logged-in user to change their own password
- **Setup utility** (`setup.php`) — guided installer for fresh deployments and admin account resets; self-deletes after use
- **Role-based access control** — Admin, Editor, and Auditor roles with appropriate page and action restrictions
- **IP-based login rate limiting** — 5 failed attempts triggers a 15-minute lockout, tracked in `data/login_attempts.json`
- **CSRF protection** on all state-changing forms
- **Session ID regeneration** on successful login
- **Flat-file storage** — all data stored in `data/` as CSV and JSON; no database required
- **Retro OS/2 Warp-inspired theme** (`assets/os2-theme.css`) with beveled windows, navy title bars, and classic gray chrome
- **Sidebar navigation** (`_sidebar.php`) with role-aware menu items and active-page highlighting
- **Organization settings** stored in `data/org_settings.json` — editable from the dashboard by Editors and Admins
- **Automatic waitlist numbering** with sequential ID assignment on new entries
- **4-character random alphanumeric IDs** for inventory items
- **File locking** (`flock()`) on all CSV writes to prevent data corruption under concurrent access
