# LapMinAcc — Laptop Ministry Accounting System

**Version 1.03**

A lightweight, self-contained web application for managing laptop donations, inventory, and recipient waitlists for the [Laptop Ministry](https://laptopministry.org) at Peoples Church of Chicago.

---

## Overview

LapMinAcc tracks the full lifecycle of donated laptops — from intake through refurbishment to distribution — without requiring a database server or external dependencies. All data is stored as flat CSV and JSON files, making it easy to deploy on any shared PHP host.

The system serves two audiences:

- **Public visitors** — Submit laptop requests and view fulfillment statistics via the public-facing home page.
- **Staff** — Manage the waitlist, inventory, and reports through a password-protected admin panel.

---

## Features

### Public
- Laptop request submission form with hardware preference checkboxes and math captcha
- Donation information panel (drop-off address, hours, contact)
- Live fulfillment statistics and monthly pickup trends
- Inventory status overview (ready units, vintage items, utilization rate)
- Welcome modal for first-time visitors (content editable by staff)

### Staff — Waitlist
- Add, edit, and delete waitlist entries
- Assign inventory items to recipients
- Track priority status, computer readiness, and pickup dates
- Record hardware preferences and need descriptions
- Search and filter entries

### Staff — Inventory
- Log donated computers and parts with donor info and estimated value
- Categorize by type (Computer / Part) and status (Ready / Repair / Parts / Vintage)
- Track tax letter requests for donors
- Mark items as discarded/recycled

### Staff — Reports
- Categorize requests by need (Education, Employment, Housing, Recovery, etc.)
- Date-range filtering for requests and pickups
- Monthly request vs. pickup trend comparison
- Demographic tracking (gender, age range)
- CSV export

### Staff — Data Tools
- **Import**: Upload CSV files for waitlist or inventory with column mapping and preview
- **Export**: Download full waitlist CSV, inventory CSV, or pickup report
- **Reconcile**: Find and repair orphaned or invalid inventory assignments

### Administration
- User management with three roles: **Admin**, **Editor**, **Auditor** (read-only)
- Organization settings editor (donation address, contact info, public welcome text)
- Guided setup/reset utility (`setup.php`) — self-deletes after use

---

## Tech Stack

| Layer | Technology |
|---|---|
| Backend | PHP 7.4+ |
| Storage | Flat files (CSV + JSON) |
| Frontend | HTML5, CSS (Grid / Flexbox), Vanilla JS |
| Theme | Custom retro OS/2 Warp-inspired CSS |
| Auth | Session-based with bcrypt password hashing |

No database engine, no Composer packages, no npm — just PHP and a web server.

---

## Security

- IP-based login rate limiting (5 attempts → 15-minute lockout)
- Math captcha on public form and login page
- Honeypot field for bot detection on public form
- CSRF token verification on all state-changing forms
- Role-based access control (Admin / Editor / Auditor)
- Output escaping via `htmlspecialchars()` throughout
- Session ID regeneration on login

---

## Installation

1. Upload all files to your PHP-capable web host.
2. Ensure the `data/` directory is **writable** by the web server.
3. Navigate to `setup.php` in your browser and follow the prompts to create the initial admin account.
4. **Delete `setup.php` from the server** after setup is complete (the script reminds you).
5. Log in at `login.php`.

### To reset the admin account later

1. Create a file at `data/setup.key` containing a passphrase of your choice.
2. Visit `setup.php`, enter that passphrase, and follow the prompts.
3. Delete `setup.php` again when done.

---

## Data Storage

| File | Contents |
|---|---|
| `data/waitlist.csv` | All waitlist entries (15 fields) |
| `data/inventory.csv` | All donated items (12 fields) |
| `data/users.json` | Staff accounts (bcrypt-hashed passwords) |
| `data/org_settings.json` | Public page content and organization info |
| `data/login_attempts.json` | IP-based rate limit tracking (auto-managed) |

Back up the `data/` directory regularly to preserve your records.

---

## User Roles

| Role | Waitlist | Inventory | Reports | Import | Export | Reconcile | Users | Settings |
|---|---|---|---|---|---|---|---|---|
| Admin | Edit | Edit | View | Yes | Yes | Yes | Yes | Yes |
| Editor | Edit | Edit | View | Yes | Yes | Yes | No | Yes |
| Auditor | View | View | View | No | Yes | No | No | No |

---

## Project Context

The Laptop Ministry has operated as an official ministry of Peoples Church of Chicago since April 2023. Its mission is to collect donated laptops, securely wipe them, install Linux, and distribute them free of charge to neighbors in need across Chicago.

---

## License

Released under the **Laptop Ministry Open Source Attribution Share-Alike License**.

You are free to use, modify, and redistribute this software provided that:

1. **Attribution** — Credit is given to the Laptop Ministry (laptopministry.org) in any derivative work or deployment.
2. **Share-Alike** — Any modified or derivative version is released under these same terms.

This software is provided as-is, without warranty of any kind.
