<?php
$currentPage = basename($_SERVER['SCRIPT_NAME']);
?>
<div class="sidebar">
    <h3>Accounting</h3>
    <nav>
        <a href="dashboard.php" class="<?= ($currentPage == 'dashboard.php') ? 'active' : '' ?>">Dashboard</a>
        <a href="waitlist.php" class="<?= ($currentPage == 'waitlist.php') ? 'active' : '' ?>">Waitlist</a>
        <a href="inventory.php" class="<?= ($currentPage == 'inventory.php') ? 'active' : '' ?>">Inventory</a>
        <?php if (isset($_SESSION['role']) && $_SESSION['role'] !== 'auditor'): ?>
            <a href="reconcile.php" class="<?= ($currentPage == 'reconcile.php') ? 'active' : '' ?>">Reconcile</a>
            <a href="import.php" class="<?= ($currentPage == 'import.php') ? 'active' : '' ?>">Import</a>
        <?php endif; ?>
        <a href="export.php" class="<?= ($currentPage == 'export.php') ? 'active' : '' ?>">Export</a>
        <a href="reports.php" class="<?= ($currentPage == 'reports.php') ? 'active' : '' ?>">Reports</a>
        <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'admin'): ?>
            <a href="users.php" class="<?= ($currentPage == 'users.php') ? 'active' : '' ?>">Users</a>
        <?php endif; ?>
    </nav>
    <div class="user-info">
        Logged in as: <strong><?= isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'User' ?></strong>
        <a href="profile.php" class="<?= ($currentPage == 'profile.php') ? 'active' : '' ?>">Change Password</a>
        <a href="logout.php">Logout</a>
    </div>
</div>
