<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

function require_admin() {
    if ($_SESSION['role'] !== 'admin') {
        die('Access Denied: You must be an admin to view this page.');
    }
}

function can_edit() {
    return in_array($_SESSION['role'], ['admin', 'editor']);
}

function require_editor() {
    if (!can_edit()) {
        die('Access Denied: Your account has read-only access.');
    }
}

function csrf_token() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function csrf_field() {
    return '<input type="hidden" name="csrf_token" value="' . csrf_token() . '">';
}

function verify_csrf() {
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        die('Invalid request. Please go back and try again.');
    }
}
