<?php
require_once 'auth.php';

$waitlist_file = __DIR__ . '/data/waitlist.csv';
$inventory_file = __DIR__ . '/data/inventory.csv';

// Handle download
if (isset($_GET['dl'])) {
    $type = $_GET['dl'];
    $timestamp = date('Ymd-His');

    if ($type === 'waitlist' && file_exists($waitlist_file)) {
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $timestamp . '-waitlist.csv"');
        readfile($waitlist_file);
        exit;
    }

    if ($type === 'inventory' && file_exists($inventory_file)) {
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $timestamp . '-inventory.csv"');
        readfile($inventory_file);
        exit;
    }

    if ($type === 'report' && file_exists($waitlist_file)) {
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $timestamp . '-waitlist-report.csv"');

        $fh = fopen($waitlist_file, 'r');
        $headers = fgetcsv($fh);
        $report_data = [];
        $date_formats = ['m/d/y', 'Y-m-d', 'Ymd'];

        while (($row = fgetcsv($fh)) !== false) {
            if (count($row) < 14) continue;
            if (trim($row[11]) === 'Y' && !empty(trim($row[12]))) {
                $pickup_date = false;
                foreach ($date_formats as $fmt) {
                    $d = DateTime::createFromFormat($fmt, trim($row[12]));
                    if ($d && $d->format($fmt) === trim($row[12])) {
                        $pickup_date = $d;
                        break;
                    }
                }
                if ($pickup_date) {
                    $report_data[] = [
                        'date' => $pickup_date,
                        'formatted' => $pickup_date->format('m/d/y'),
                        'need' => $row[13] ?? ''
                    ];
                }
            }
        }
        fclose($fh);

        usort($report_data, fn($a, $b) => $a['date'] <=> $b['date']);

        $out = fopen('php://output', 'w');
        fputcsv($out, ['Days Since Last Pickup', 'Pickup Date', 'Need Description']);
        $last = null;
        foreach ($report_data as $entry) {
            $days = $last ? $entry['date']->diff($last)->days : 0;
            fputcsv($out, [$days, $entry['formatted'], $entry['need']]);
            $last = $entry['date'];
        }
        fclose($out);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Export - Laptop Ministry Accounting</title>
    <link rel="stylesheet" href="assets/os2-theme.css">
    <link rel="stylesheet" href="assets/custom.css">
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; ?>
        <main class="content">
            <div class="window">
                <div class="window-title">Export Data</div>
                <div class="window-content">
                    <p>Download CSV files for your records or for use in spreadsheet applications.</p>

                    <fieldset>
                        <legend>Waitlist</legend>
                        <p>Full waitlist data including all entries, statuses, and notes.</p>
                        <div class="quick-links">
                            <a href="?dl=waitlist">Download Waitlist CSV</a>
                            <a href="?dl=report">Download Pickup Report</a>
                        </div>
                    </fieldset>

                    <br>

                    <fieldset>
                        <legend>Inventory</legend>
                        <p>Complete inventory of donated items, values, and status.</p>
                        <div class="quick-links">
                            <a href="?dl=inventory">Download Inventory CSV</a>
                        </div>
                    </fieldset>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
