<?php
session_start();

// Already logged in — go straight to dashboard
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit;
}

// Generate a fresh captcha on every GET request
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $_SESSION['login_captcha_a']   = rand(2, 9);
    $_SESSION['login_captcha_b']   = rand(1, 9);
    $_SESSION['login_captcha_sum'] = $_SESSION['login_captcha_a'] + $_SESSION['login_captcha_b'];
}

// Resolve error message
$error  = '';
$locked = false;
$err    = $_GET['error'] ?? '';

if ($err === 'locked') {
    $locked = true;
    $mins   = max(1, intval($_GET['mins'] ?? 15));
    $error  = "Too many failed attempts. Please try again in {$mins} minute" . ($mins !== 1 ? 's' : '') . '.';
} elseif ($err === 'captcha') {
    $error = 'Incorrect answer to the math question. Please try again.';
} elseif ($err === '1') {
    $left  = intval($_GET['left'] ?? 0);
    $error = 'Invalid username or password.'
           . ($left > 0 ? " ({$left} attempt" . ($left !== 1 ? 's' : '') . ' remaining before lockout)' : '');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Staff Login &mdash; Laptop Ministry</title>
    <link rel="stylesheet" href="assets/os2-theme.css">
    <link rel="stylesheet" href="assets/custom.css">
    <style>
        body {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            gap: 12px;
            padding: 20px;
        }
        .login-box { width: 100%; max-width: 320px; }
        .lockout-msg {
            background: #fff0f0;
            border: 2px solid #cc0000;
            padding: 10px 14px;
            font-size: 13px;
            color: #660000;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="login-box">
        <?php if ($locked): ?>
            <div class="lockout-msg">
                &#128274; <?= htmlspecialchars($error) ?>
            </div>
        <?php else: ?>
        <fieldset class="window">
            <legend class="window-title">Staff Login</legend>
            <?php if ($error): ?>
                <p class="error"><?= htmlspecialchars($error) ?></p>
            <?php endif; ?>
            <form action="login_handler.php" method="POST" autocomplete="off">
                <div>
                    <label for="username">Username:</label>
                    <input type="text" id="username" name="username" required autocomplete="username">
                </div>
                <div>
                    <label for="password">Password:</label>
                    <input type="password" id="password" name="password" required autocomplete="current-password">
                </div>
                <div style="margin-top:8px;">
                    <label for="captcha_input">
                        What is <?= (int)$_SESSION['login_captcha_a'] ?> + <?= (int)$_SESSION['login_captcha_b'] ?>?
                    </label>
                    <input type="number" id="captcha_input" name="captcha_input"
                           required min="0" max="99" autocomplete="off"
                           style="max-width:90px;">
                </div>
                <button type="submit" style="margin-top:10px;">Login</button>
            </form>
        </fieldset>
        <?php endif; ?>
    </div>
    <p style="font-size:12px;color:#666;">
        <a href="index.php">&larr; Back to public site</a>
    </p>
</body>
</html>
