<?php
require_once 'auth.php';

$users_file = __DIR__ . '/data/users.json';
$message = '';
$msg_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    $current_pass = $_POST['current_password'] ?? '';
    $new_pass = $_POST['new_password'] ?? '';
    $confirm_pass = $_POST['confirm_password'] ?? '';

    if ($new_pass !== $confirm_pass) {
        $message = 'New passwords do not match.';
        $msg_type = 'error';
    } elseif (strlen($new_pass) < 6) {
        $message = 'New password must be at least 6 characters.';
        $msg_type = 'error';
    } else {
        $users = json_decode(file_get_contents($users_file), true);
        $updated = false;

        foreach ($users as $i => $user) {
            if ($user['id'] == $_SESSION['user_id']) {
                if (password_verify($current_pass, $user['hash'])) {
                    $users[$i]['hash'] = password_hash($new_pass, PASSWORD_DEFAULT);
                    $updated = true;
                } else {
                    $message = 'Current password is incorrect.';
                    $msg_type = 'error';
                }
                break;
            }
        }

        if ($updated) {
            file_put_contents($users_file, json_encode($users, JSON_PRETTY_PRINT), LOCK_EX);
            $message = 'Password updated.';
            $msg_type = 'success';
        } elseif (empty($message)) {
            $message = 'User not found. Please log out and back in.';
            $msg_type = 'error';
        }
    }
}

$token = csrf_token();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile - Laptop Ministry Accounting</title>
    <link rel="stylesheet" href="assets/os2-theme.css">
    <link rel="stylesheet" href="assets/custom.css">
</head>
<body>
    <div class="admin-wrapper">
        <?php include '_sidebar.php'; ?>
        <main class="content">
            <div class="window">
                <div class="window-title">Change Your Password</div>
                <div class="window-content">
                    <?php if ($message): ?>
                        <p class="<?= $msg_type ?>"><?= htmlspecialchars($message) ?></p>
                    <?php endif; ?>

                    <form method="POST">
                        <input type="hidden" name="csrf_token" value="<?= $token ?>">
                        <div class="form-row">
                            <label>Current Password:</label>
                            <input type="password" name="current_password" required>
                        </div>
                        <div class="form-row">
                            <label>New Password:</label>
                            <input type="password" name="new_password" required>
                        </div>
                        <div class="form-row">
                            <label>Confirm New Password:</label>
                            <input type="password" name="confirm_password" required>
                        </div>
                        <button type="submit">Update Password</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
